<?php
class ControllerExtensionModuletntfooterlogo extends Controller {
    private $error = array();
    public function index() {
        $this->load->language('extension/module/tntfooterlogo');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('setting/module');
        $this->load->model('tool/image');
        $this->load->model('localisation/language');
$this->session->data['module_id'] = $this->request->get['module_id'];
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            
            if (!isset($this->request->get['module_id'])) {
                $this->model_setting_module->addModule('tntfooterlogo', $this->request->post);
            } else {
                $this->model_setting_module->editModule($this->request->get['module_id'], $this->request->post);
            }
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('extension/module/tntfooterlogo', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->session->data['module_id'], true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning']  = $this->error['warning'];
        } else {
            $data['error_warning']  = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name']     = $this->error['name'];
        } else {
            $data['error_name']     = '';
        }

        $data['breadcrumbs']        = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
        );

        if (!isset($this->request->get['module_id'])) {
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/tntfooterlogo', 'user_token=' . $this->session->data['user_token'], true)
            );
        } else {
            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('extension/module/tntfooterlogo', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], true)
            );
        }

        if (!isset($this->request->get['module_id'])) {
            $data['action'] = $this->url->link('extension/module/tntfooterlogo', 'user_token=' . $this->session->data['user_token'], true);
        } else {
            $data['action'] = $this->url->link('extension/module/tntfooterlogo', 'user_token=' . $this->session->data['user_token'] . '&module_id=' . $this->request->get['module_id'], true);
        }

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

        if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $module_info = $this->model_setting_module->getModule($this->request->get['module_id']);
        }

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->request->post['name'])) {
            $data['name'] = $this->request->post['name'];
        } elseif (!empty($module_info)) {
            $data['name'] = $module_info['name'];
        } else {
            $data['name'] = '';
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($module_info)) {
            $data['status'] = $module_info['status'];
        } else {
            $data['status'] = "";
        }

        if (isset($this->request->post['tntfooterlogo_description'])) {
            $data['tntfooterlogo_description'] = $this->request->post['tntfooterlogo_description'];
            foreach ($this->request->post['tntfooterlogo_description'] as $key => $value) {
                if($value['image']){
                    $data['image'][$key] =  $this->model_tool_image->resize($value['image'], 100, 100);               
                }else{
                    $data['image'][$key] =  $this->model_tool_image->resize('no_image.png', 100, 100);
                }
            }
        } elseif (!empty($module_info)) {
            $data['tntfooterlogo_description'] = $module_info['tntfooterlogo_description'];
            foreach ($module_info['tntfooterlogo_description'] as $key => $value) {
                $data['image'][$key] =  $this->model_tool_image->resize($value['image'], 100, 100);               
            }
        } else {
            foreach ($data['languages'] as $key => $value) {
                $data['image'][$value['language_id']] =  $this->model_tool_image->resize('no_image.png', 100, 100);              
            }
            $data['tntfooterlogo_description'] = array();
        }

        $data['header']         = $this->load->controller('common/header');
        $data['column_left']    = $this->load->controller('common/column_left');
        $data['footer']         = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/tntfooterlogo', $data));
    }
    public function install(){

        $settingdata           = array();
        $settingdata['name']   = "Footer Logo";
        $settingdata['status'] = 1;

        $this->load->model('setting/module');
        $this->load->model('localisation/language');

        $languages = $this->model_localisation_language->getLanguages();

        foreach ($languages as $value) {
            $settingdata['tntfooterlogo_description'][$value['language_id']] = array('image'=>'catalog/themefactory/logo/Footer-Logo.png','title'=>'title','description'=>'Lorem ipsum Dolor Sit amet, consectetur adip isicing elit, sed do eiusmod tempor incidi-dunt.','short_description'=>'Lorem ipsum Dolor Sit amet, consectetur adip isicing elit, sed do eiusmod tempor incidi-dunt.');
        }

        $this->model_setting_module->addModule('tntfooterlogo', $settingdata);
    
    }

    protected function status(){
        return $this->webvoltystatus->footerstatus();
    }
    
    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/tntfooterlogo')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
            $this->error['name'] = $this->language->get('error_name');
        }
        return !$this->error;
    }
}
